# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MonitorCounterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "monitor counters"

   def __init__( self, param ):
      self.modeKey = "mon-counters"
      self.longModeKey = "mon-counters"
      CliMode.ConfigMode.__init__( self, param )

class MonitorCounterEthernetMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "ethernet interfaces"

   def __init__( self, param ):
      self.modeKey = "mon-counters-ethintfs"
      self.longModeKey = "mon-counters-ethintfs"
      CliMode.ConfigMode.__init__( self, param, parentMode=MonitorCounterMode )

class MonitorQueueCounterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "queue counters"

   def __init__( self, param ):
      self.modeKey = "mon-counters-queue"
      self.longModeKey = "mon-counters-queue"
      CliMode.ConfigMode.__init__( self, param, parentMode=MonitorCounterMode )
