#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ServerGroupMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'aaa group server %s' % self.param_

   def __init__( self, groupType, groupName ):
      self.modeKey = "sg-%s" % groupType
      self.longModeKey = "sg-%s-%s" % ( groupType, groupName )
      CliMode.ConfigMode.__init__( self, groupType + ' ' + groupName )

class RoleMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'role %s' % self.param_

   def __init__( self, role ):
      self.modeKey = "role"
      self.longModeKey = "role-%s" % role
      CliMode.ConfigMode.__init__( self, role )
