#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import weakref
import Plugins

__pluginsLoaded__ = None

# import various plugins needed for Cli/CliSave
def loadPlugins( context ):
   global __pluginsLoaded__
   if not ( __pluginsLoaded__ and
            __pluginsLoaded__() == context ): # pylint: disable-msg=E1102
      # CliMode is not really plugins, but we import all files under the
      # directory. This makes sure that we don't forget to do so (e.g.,
      # those with only convertLongnameToShortname()).
      Plugins.loadPlugins( "CliMode", context=None )
      Plugins.loadPlugins( "IntfRangePlugin", context=context )
      __pluginsLoaded__ = weakref.ref( context )
