# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import cPickle

import FastServUtil

class CliInterface( object ):
   def tabComplete( self, cmd ):
      raise NotImplementedError

   def printHelp( self, cmd ):
      raise NotImplementedError

   def prompt( self, promptPrefix ):
      raise NotImplementedError

   def getHistoryKeys( self ):
      raise NotImplementedError

   def getOrigModeHistoryKeys( self ):
      raise NotImplementedError

   def getParentHistoryKeys( self ):
      raise NotImplementedError

   def exitConfigMode( self ):
      raise NotImplementedError

   def runCmd( self, cmd, aaa=True ):
      raise NotImplementedError

   def handleCliException( self, exc_info, cmd, lineNo=None,
                           handleKeyboardInterrupt=True ):
      raise NotImplementedError

   def endSession( self ):
      raise NotImplementedError

class LocalCliInterface( CliInterface ):
   def __init__( self, session ):
      self.session_ = session

   def tabComplete( self, cmd ):
      return self.session_.tabComplete( cmd )

   def printHelp( self, cmd ):
      return self.session_.printHelp( cmd )

   def prompt( self, promptPrefix ):
      return self.session_.prompt( promptPrefix )

   def getHistoryKeys( self ):
      return self.session_.getHistoryKeys()

   def getOrigModeHistoryKeys( self ):
      return self.session_.getOrigModeHistoryKeys()

   def getParentHistoryKeys( self ):
      return self.session_.getParentHistoryKeys()

   def exitConfigMode( self ):
      return self.session_.exitConfigMode()

   def runCmd( self, cmd, aaa=True ):
      return self.session_.runCmd( cmd, aaa )

   def handleCliException( self, exc_info, cmd, lineNo=None,
                           handleKeyboardInterrupt=True ):
      return self.session_.handleCliException( exc_info, cmd, lineNo,
                                               handleKeyboardInterrupt )

   def endSession( self ):
      pass

class _RemoteRequest( object ):
   def __init__( self, method, args, kwargs ):
      self.method_ = method
      self.args_ = args
      self.kwargs_ = kwargs

class _RemoteAttr( object ):
   def __init__( self, method, cliShell, sessionSock ):
      self.method_ = method
      self.cliShell_ = cliShell
      self.sessionSock_ = sessionSock

   def __call__( self, *args, **kwargs ):
      try:
         self.cliShell_.disableIsig()
         request = _RemoteRequest( self.method_, args, kwargs )
         requestStr = cPickle.dumps( request )
         FastServUtil.writeString( self.sessionSock_, requestStr )
         responseStr = FastServUtil.readString( self.sessionSock_ )
         if not responseStr:
            return
         response = cPickle.loads( responseStr )
         if ( issubclass( type( response ), Exception ) or
              type( response ) is SystemExit ):
            raise response
         return response
      finally:
         self.cliShell_.enableIsig()

class RemoteCliInterface( CliInterface ): # pylint: disable-msg=W0223
   def __init__( self, cliShell, sessionSock ):
      self.cliShell_ = cliShell
      self.sessionSock_ = sessionSock

   def __getattribute__( self, name ):
      if name == 'sessionSock_' or name == 'cliShell_':
         return super( RemoteCliInterface, self ).__getattribute__( name )
      return _RemoteAttr( name, self.cliShell_, self.sessionSock_ )
