# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

######################################################################
#
# Guard codes.
#
# guard functions should return None, or one of these.
#

guardNotThisEosVersion = 'unimplemented in this EOS version'
guardNotThisAbootVersion = 'unimplemented in this Aboot version'
guardNotThisPlatform = 'not supported on this hardware platform'
guardNoLicense = 'additional software license required'
guardNotThisSupervisor = 'not available on this supervisor'
guardNotSsoProtocol = 'only supported for sso protocol'
guardNonDefaultVrf = 'not supported in non-default vrf'
guardNotPermitted = 'not permitted for the current user'

allGuards = ( guardNotThisEosVersion, guardNotThisAbootVersion,
              guardNotThisPlatform, guardNoLicense,
              guardNotThisSupervisor, guardNotSsoProtocol, guardNonDefaultVrf,
              guardNotPermitted )
#
# end guard codes.
#
######################################################################
