#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def tacMdName( mdName, mdNameFormat ):
   return Tac.Value( 'Cfm::MdNameWithFormat', mdName, mdNameFormat )

def tacMaName( maName, maNameFormat ):
   return Tac.Value( 'Cfm::MaNameWithFormat', maName, maNameFormat )

def tacIntf( intf ):
   return Tac.Value( 'Arnet::IntfId', intf )

tacMepDirection = Tac.Type( 'Cfm::MepDirection' )
defaultMepDirection = tacMepDirection.MepDirectionDown
defaultCfmProfileName = Tac.Type( 'Cfm::CfmProfileName' ).defaultCfmProfileName
defaultPrimaryVlanId = 0
