#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import namedtuple
import random

ccmTxIntervalUnitMultiplier = { 'seconds' : 1, 'milliseconds' : 0.001,
                                'minutes' : 60 }

def getCcmTxInterval( ccmTxInterval=1, unit='seconds' ):
   return float( ccmTxInterval ) * ccmTxIntervalUnitMultiplier[ unit ]

CcmTxIntervalWithUnit = namedtuple( 'CcmTxIntervalWithUnit', 'ccmTxInterval, unit' )
ccmTxIntervalToCliToken = {}
randomCcmTxIntervalUnit = random.choice( ccmTxIntervalUnitMultiplier.keys() )
for ccmTxIntervalWithUnit in [ CcmTxIntervalWithUnit( 3.33, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 10, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 100, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 1, 'seconds' ),
                               CcmTxIntervalWithUnit( 10, 'seconds' ),
                               CcmTxIntervalWithUnit( 1, 'minutes' ),
                               CcmTxIntervalWithUnit( 10, 'minutes' ) ]:
   ccmTxIntervalToCliToken[
      getCcmTxInterval(
         **ccmTxIntervalWithUnit._asdict() # pylint: disable=protected-access
      ) ] = ccmTxIntervalWithUnit

defaultCcmTxIntervalWithUnit = CcmTxIntervalWithUnit( 1, 'seconds' )
assert defaultCcmTxIntervalWithUnit in ccmTxIntervalToCliToken.values()

ieeeMdNameMaxLen = 43
ieeeMaNameMaxLen = 45
