#!/usr/bin/env python

# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class CeosMode( object ):
   checkKernelVersion = True
   disabledAgents = []
   enableCapi = False
   enableHostSyslog = False
   enableRoutingModelMultiAgent = False
   disableSpanningTree = False
   generateKickStart = False
   enableRouting = False
   enableRoutedMode = False
   configHostname = False
   extKickstart = False
   linuxKernelForwarding = False

class CeosLabMode( CeosMode ):
   checkKernelVersion = False
   generateKickStart = True
   disabledAgents = [
      "LicenseManager", "PowerFuse", "PowerManager", "Thermostat", "LedPolicy",
      "StandbyCpld", "Bfd"
   ]

class CeosRouterMode( CeosMode ):
   checkKernelVersion = False
   enableCapi = True
   enableRouting = True
   enableRoutedMode = True
   configHostname = True
   generateKickStart = True
   disabledAgents = [
      "LicenseManager", "PowerFuse", "PowerManager", "Thermostat", "LedPolicy",
      "StandbyCpld", "SampledFlowTrac",
      "CloudHa", "Bfd", "Ipsec", "Tunnel", "Acl", "Qos", "PortSec",
      "TopoAgent", "L2Rib", "LacpTx", "Lag", "LacpTxAgent",
      "McastCommon", "McastCommon6", "IgmpSnooping", "Stp", "StpTxRx", "StpTopology",
   ]
   extKickstart = True
   linuxKernelForwarding = True

class CeosSonicMode( CeosMode ):
   enableCapi = True
   enableHostSyslog = True
   enableRoutingModelMultiAgent = True
   disableSpanningTree = True
   generateKickStart = True
   # List of agent is currently added manually.
   # As the requirements clarify, we can add more agents to this list
   # BUG233727 - If we ever need to use unix sockets for CAPI, we can add SuperServer
   # back to agentList.
   disabledAgents = [
      # Unicast Protocols with empty config
      "KernelFib", "Bfd", "Ipv6RouterAdvt", "ArpInspection",
      # Multicast Protocols are disabled by default
      # L2 Protocols that start with empty config
      "IgmpSnooping", "Stp", "StpTxRx", "Fhrp", "Lldp",
      # Others that start with empty config
      "Mirroring",
   ]

class CeosSaiMode( CeosMode ):
   checkKernelVersion = False
   enableCapi = True
   enableRoutingModelMultiAgent = True
   disableSpanningTree = True
   generateKickStart = True
   # BUG274076 tracks the progress of the agent blacklist for the SAI mode
   disabledAgents = [
      # Unicast Protocols with empty config
      "KernelFib", "Bfd", "Ipv6RouterAdvt", "ArpInspection",
      # Multicast Protocols are disabled by default
      # L2 Protocols that start with empty config
      "IgmpSnooping", "Stp", "StpTxRx", "Fhrp", "Lldp",
      # Others that start with empty config
      "Mirroring",
   ]

Modes = {
   "lab" : CeosLabMode,
   "ceosr" : CeosRouterMode,
   "sai" : CeosSaiMode,
   "sonic" : CeosSonicMode,
   "unknown" : CeosMode,
}
