# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, PyClient
import socket

class AgentPauseFailure( Exception ): pass

def agentAddr( agentName ):
   import AgentDirectory
   try:
      address = AgentDirectory.address( Tac.sysname(), agentName, 'localhost' )
   except KeyError:
      address = None
   return address

def getPausePort( agentName, accelId, verbose ):
   addr = agentAddr( agentName )
   if not addr:
      return None
   try:
      if verbose:
         print "Attempting to pause running", agentName, "agent for accelId", accelId
      pc = PyClient.PyClient( Tac.sysname(), agentName )
      cmd = """
s = Tac.entity('/%s/%s/agentStatus')
print s.pausePort[ '%s' ]""" %( Tac.sysname(), agentName.lower(), accelId )
      result = pc.execute( cmd )
      port = int( result )
      if port != 0:
         if verbose:
            print "Using port", port, "to pause accelId", accelId
         return port
      else:
         raise AgentPauseFailure( "Unexpected result from PyClient to %s "
                                       "agent" %( agentName ) )
   except Exception, e:
      raise AgentPauseFailure( "PyClient to %s agent failed: %s" %( agentName, e ) )

def connectToPausePort( port ):
   sock = socket.socket( socket.AF_INET, socket.SOCK_STREAM )
   sock.connect( ('127.0.0.1', port) )
   return sock
 
def sendPauseCommand( sock ):
   sock.send( "pause\r\n" )
   # wait for the agent to acknowledge
   response = sock.recv( 8 )
   return ( response == "paused\r\n" )

def sendUnpauseCommand( sock ):
   sock.send( "unpause\r\n" )
   # wait for the agent to acknowledge
   response = sock.recv( 10 )
   return ( response == "unpaused\r\n" )

def pauseAgentIfNecessary( agentName, accelId, verbose ):
   """Checks to see if the agent is running, determines the pause port if the agent
   is running, connects to the port, and issues a pause command.  Returns a socket
   that can be passed to unpauseAgentIfNecessary.  The agent will unpause
   automatically when the connection on this socket is closed.
   """

   if agentName == "Smbus":
      assert 0, "BUG2909 - Smbus agent pause support completely broken"

   port = getPausePort( agentName, accelId, verbose )
   if not port:
      return None
   sock = connectToPausePort( port )
   sendPauseCommand( sock )
   return sock 

def unpauseAgentIfNecessary( sock, verbose ):
   """If sock is a connected socket, sends an unpause command over the connection.
   Returns True if either nothing needed to be done, or if the unpause was
   successful.   
   """
   if sock:
      if verbose:
         print "Attempting to unpause agent"
      return sendUnpauseCommand( sock )
   return True


