#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac


def tacBrTypeVal( brTypeStr ):
   enum = Tac.Type( 'Bridging::BrType' )
   return getattr( enum, brTypeStr )

def vlanIdToBrId( vlanId ): 
   '''
   convert Bridging::VlanId to Bridging::BridgeId
   '''
   brType = tacBrTypeVal ( 'brTypeVlan' )
   BridgeId = Tac.Type( "Bridging::BridgeId" )
   return BridgeId( brType, vlanId ).constMe()

def vniToBrId( vni ): 
   '''
   convert a VNI to Bridging::BridgeId
   '''
   brType = tacBrTypeVal ('brTypeVni')
   BridgeId = Tac.Type( "Bridging::BridgeId")
   return BridgeId( brType, vni ).constMe()
