# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

## If we implement the global bgp maximum-routes command, then we will
# need to add these two log messages:
# NOTE: This message is output only by ribd, in src/bgp/bgp_rt.c.
# We include it here simply to get it into the log message guide.
Logging.logD(
   id="BGP_MAXROUTES",
   severity=Logging.logNotice,
   format="BGP has exceeded its configured maximum total number "
   "of routes (%d); ROUTING INFORMATION IS BEING LOST",
   explanation="BGP has received more routes than it is configured "
   "to handle.  It will not accept any more routes.  Routing information "
   "may be incomplete, and may get further out of date.",
   recommendedAction="Determine whether the number of shared BGP routes is "
   "reasonable.  Then, either reduce the number of routes being shared "
   "by your BGP peers, or increase the maximum-routes limit.  After taking "
   "either of these actions issue the 'clear ip bgp *|<peer>' command, to "
   "reset the BGP peer connection." )

Logging.logD(
   id="BGP_PEER_CLEAR",
   severity=Logging.logNotice,
   format="BGP %s by %s on %s (%s)%s",
   explanation="BGP peering was reset by CLI command",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

# NOTE: The following message is logged by Linux kernel, and transformed
# by EOS rsyslogd into industry standard format. Included here to get into 
# documentation

Logging.logD(
   id='TCP_BADAUTH',
   severity=Logging.logNotice,
   format="Invalid/Unexpected/No MD5 digest from %s(%d) to %s(%d)",
   explanation="Passwords of BGP peers are not identical",
   recommendedAction="Make sure that passwords, if configured, are "
   "configured on both peers, and that they are identical.")


# NOTE: This message is output only by ribd, in src/bgp/bgp_send.c.
# We include it here simply to get it into the log message guide.
Logging.logD(
   id="MESSAGE_SIZE_EXCEEDED",
   severity=Logging.logWarning,
   format="BGP is unable to send an update message as the message is too large "
   "(%u of %d bytes)",
   explanation="A BGP update message was generated which is too large to send. "
   "BGP limits the maximum message size. If BGP generates an update message "
   "that exceeds this maximum message size, then the update message is not sent "
   "as the peer would reject it. This occurs when the length of the path "
   "attributes for one or more routes is near to or exceeds the maximum "
   "message size.",
   recommendedAction="Check to see if any routes have any large attributes. "
   "A large ASPATH could indicate a ASPATH loop has formed. A router could "
   "also be attaching large unknown transitive attibutes. Take steps to "
   "reduce the attribute length for affected routes."
   )

# NOTE: This message is output only by ribd, in src/bgp/bgp_send.c.
# We include it here simply to get it into the log message guide.
Logging.logD(
   id="UPDATE_SIZE_EXCEEDED",
   severity=Logging.logWarning,
   format="BGP is unable to construct an update for route (%A/%d) as the "
   "BGP message would be too large to send. Attribute path length requires at "
   "least %u bytes.",
   explanation="A BGP update message for given route was generated which is "
   "too large to send. BGP limits the maximum message size. If BGP generates "
   "an update message that exceeds this maximum message size, then the update "
   "message is not sent as the peer would reject it. This occurs when the "
   "length of the path attributes for the route is near to or exceeds the "
   "maximum message size.",
   recommendedAction="Check the route to see if it has any large attributes. "
   "A large ASPATH could indicate a ASPATH loop has formed. A router could "
   "also be attaching large unknown transitive attibutes. Take steps to "
   "reduce the attribute length for affected routes."
   )
