#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import json
from EosCloudInitLib import userData, configFile, runCmd, \
   startMark, processUserData, setupConnection, cleanupExit, \
   copyDefaultStartupConfig, firstTimeBoot, metadataIp, getDnsIp

# pkgdeps: rpmwith %{_libdir}/libCloudUtils.so*

# AWS urls for userdata and keys
userDataUrl = 'http://%s/latest/user-data' % metadataIp
cloudKeysUrl = 'http://%s/latest/meta-data/public-keys/0/openssh-key' % metadataIp
cloudKeys = "/mnt/flash/key.pub"
instanceIdentityUrl = ( 'http://%s/latest/dynamic/instance-identity/document'
                      % metadataIp )

configs = {
   startMark( 'AWS-CONFIG' ) : configFile( "AWS-CONFIG",
                                           "/mnt/flash/awslogs/aws.conf" ),
   startMark( 'AWSLOGS-CONFIG' ) : configFile( "AWSLOGS-CONFIG",
                                               "/mnt/flash/awslogs/awslogs.conf" ),
   startMark( 'AWS-PROXY' ) : configFile( "AWS-PROXY",
                                          "/mnt/flash/awslogs/proxy.conf" )
}

awsRegionFile = Tac.Type( "CloudUtils::AwsAttr" ).awsRegionFile
instanceIdFile = Tac.Type( "CloudUtils::CloudAttr" ).instanceIdFile
def cloudInit():
   setupConnection()

   ## Download keys
   print "Downloading cloud keys"
   _, rc = runCmd( [ "wget", cloudKeysUrl, "-O", cloudKeys ] )
   if rc != 0:
      cleanupExit( "Could not download keys. Skipping downloading user data. " +
                   "RC %d" % rc, rc )

   ## Store aws region as payg license code needs it
   instanceIdentity, rc = runCmd( [ "curl", "-s", instanceIdentityUrl ] )
   if rc != 0:
      cleanupExit( "Could not get the region. Skipping downloading user data. " +
                   "RC %d" % rc, rc )
   region = json.loads( instanceIdentity )[ 'region' ]
   instanceId = json.loads( instanceIdentity )[ 'instanceId' ]
   try:
      with open( awsRegionFile, "w" ) as fd:
         fd.write( region )
      with open( instanceIdFile, "w" ) as fd:
         fd.write( instanceId )
   except IOError:
      cleanupExit( "Failed to write instance identity information to aws files" )

   configLines = []
   configLines.append( 'ip name-server %s\n' % getDnsIp() )

   ## Download user data. Process user data if first time boot
   print "Downloading user data"
   _, rc = runCmd( ["wget", userDataUrl, "-O", userData] )
   if rc == 0:
      processUserData( configs, extraConfig=configLines )
   else:
      # can happen if user data isn't set
      print "Unable to download user data"
      # Copy the default-startup-config to startup-config
      if firstTimeBoot():
         print "First time boot Copying defaultStartup-config to Startup-config"
         copyDefaultStartupConfig( extraConfig=configLines )
