#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import os
import Tac
import AsuPStore

def getEnvAsuPStorePlugins():
   pstorePluginStr = os.environ.get( "ASU_PSTORE_PLUGINS", None )
   pstorePluginPathStr = os.environ.get( "ASU_PSTORE_PLUGIN_PATH", None )
   pstorePlugin, pstorePluginPath = None, None
   if pstorePluginStr:
      pstorePlugin = pstorePluginStr.split( ',' )
   if pstorePluginPathStr:
      pstorePluginPath = pstorePluginPathStr.split( ',' )
   return ( pstorePlugin, pstorePluginPath )

def doSaveAsuState( entityManager ):
   # plugins environ setting is used for test purpose
   envPlugins, envPluginPath = getEnvAsuPStorePlugins()
   AsuPStore.doSaveAsuState( entityManager,
                             plugins=envPlugins, pluginPath=envPluginPath )

def doGetFeatureKeys( entityManager ):
   # plugins environ setting is used for test purpose
   envPlugins, envPluginPath = getEnvAsuPStorePlugins()
   return AsuPStore.getFeatureKeys( entityManager,
                                    plugins=envPlugins, pluginPath=envPluginPath )

def doCheckHitlessReloadSupported( entityManager ):
   # plugin environ setting is used for test purpose
   envPlugins, envPluginPath = getEnvAsuPStorePlugins()
   return AsuPStore.doCheckHitlessReloadSupported(entityManager, 
                                 plugins=envPlugins, pluginPath=envPluginPath )
