#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#
# Please refer to aid/4596 before making changes here.
# We lookup the filesystem to find the exact files in AsuPatchPkgs/.
# Enter the filename (with comments) here for the patch that is retired in this
# release.
#
retiredDb = [
      # ---------
      # delhi-rel
      # ---------
      # AsuPatchArp is not needed as Arp agent will write /mnt/flash/arpAsuDb.
      'AsuPatchArp_S4_18_1_T4_22.py',
      # AleMroute and StrataL3 are not needed as corresponding agents write
      # their info to PSTORE before ASU reload.
      'AleMroute_S4_18_T4_22.py',
      'AleMroute_S4_18_T4_22.i686.rpm',
      'StrataL3_S4_20_T4_22.py',
      'StrataL3_S4_20_T4_22.i686.rpm',
      # Strata is not needed from delhi.C1 as the plugin is included
      # from delhi.C1 onward
      'Strata_S4_20_T4_22.i686.rpm',
      'Strata_S4_20_T4_22.py',
      # FpgaCliFix is not needed as issue is fixed.
      'FpgaCliFix_S4_20_T4_21_3.py',
      # AsuAllowReEcmp is not needed as it removes a plugin that is required
      # from delhi-rel onwards.
      'AsuAllowReEcmp_S4_19_8_T4_21_3.py',
      # LacpPkt is not needed from delhi.C1-rel onwards as we use AFPR for
      # handling LACP packets
      'StrataLacpPkt_S4_18_T4_21_3.py',
      # ----------
      # eugene-rel
      # ----------
      # Dot1x is not needed as the corresponding agent writes to PStore Plugin
      'Dot1x_S4_21_5T4_22.py',
      'Dot1x_S4_21_5T4_22.i686.rpm',
      'AclAgent_S4_18_8_T4_21_3.py',
      'AclAgent_S4_18_8_T4_21_3.i686.rpm',
      # StrataDmaShut is not needed in florence-rel
      'StrataDmaShut_S4_4_21_3_T_4_22.py',
      # --------------
      # geneva-rel
      # --------------
      # SandFap is not needed in geneve-rel
      'SandFap_S4_22_T4_23.py',
      'SandFap_S4_22_T4_23.i686.rpm',

      # Sand is not needed in jakarta-rel
      'Sand_S4_22_T4_24.py',
      'Sand_S4_22_T4_24.i686.rpm',
      ]
