#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class VxlanPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When vxlan interface is configured,
   this configuration will block ASU2 hitless reload.
   '''
   def __init__( self, vxlanStatusDir, bridgingHwCapabilities ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.vxlanStatusDir_ = vxlanStatusDir
      self.bridgingHwCapabilities_ = bridgingHwCapabilities

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      vxlanAsu2Supported = False
      if self.bridgingHwCapabilities_:
         vxlanAsu2Supported = self.bridgingHwCapabilities_.vxlanAsu2Supported
      if ( ( not vxlanAsu2Supported ) and self.vxlanStatusDir_ and
           self.vxlanStatusDir_.vxlanStatus ):
         blockingList.append(
            ReloadHitlessBlockingReason( reason='vxlanConfigured' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'Vxlan'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      vxlanStatusDir = mg.mount( 'vxlan/status', 'Vxlan::VxlanStatusDir', 'r' )
      bridgingHwCapabilities = mg.mount( "bridging/hwcapabilities",
                                         "Bridging::HwCapabilities", "r" )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         VxlanPStoreEventHandler( 
                                            vxlanStatusDir,
                                            bridgingHwCapabilities ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         VxlanPStoreEventHandler( None,
                                                                  None ) )
