# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

class RipAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''We should warn on ASU2 hitless reload if RIP is enabled on the switch and is
   not in shutdown state. AsuPStorePlugin's hitlessReloadSupported is used for this
   purpose. Other apis do not apply, and should not be registered.
   '''
   def __init__( self, ripConfig ):
      self.ripConfig = ripConfig
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = None, None
      for i in self.ripConfig.instanceConfig:
         if not self.ripConfig.instanceConfig[ i ].shutdown:
            warningList = [ ReloadHitlessWarningReason( reason='ripEnabled' ) ]
            break
      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'Rip'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      ripConfig = mg.mount( 'routing/rip/config', 'Routing::Rip::Config', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         RipAsuPStoreEventHandler( ripConfig ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         RipAsuPStoreEventHandler( None ) )
