# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

class PfcWdPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When PFC Watchdog is configured, a warning will be
   issued on ASU2 hitless reload.
   '''
   def __init__( self, qosInputConfig ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.qosInputConfig_ = qosInputConfig

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.qosInputConfig_ and self.qosInputConfig_.watchdogTimeout:
         warningList.append( 
               ReloadHitlessWarningReason( reason='pfcWatchdogEnabled' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'PfcWatchdog'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      qosInputConfig = mg.mount( 'qos/input/config/cli', 'Qos::Input::Config', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         PfcWdPStoreEventHandler( qosInputConfig ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         PfcWdPStoreEventHandler( None ) )
