#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

class PtpAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''ASU2 hitless reload warning for possible ptp network topology 
      re-convergence
   '''

   def __init__( self, ptpStatus ):
      self.ptpStatus_ = ptpStatus
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList = []

      if self.ptpStatus_.enabled:
         warningList.append( ReloadHitlessWarningReason( reason='ptpEnabled' ) )

      return ( warningList, [] )

def Plugin( ctx ):
   featureName = 'Ptp'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      ptpStatus = mg.mount( 'ptp/status', 'Ptp::Status', 'rO' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         PtpAsuPStoreEventHandler( ptpStatus ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         PtpAsuPStoreEventHandler( None ) )

