#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class OpenFlowAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''OpenFlow configuration blocks ASU2 hitless
   reload. AsuPStorePlugin's hitlessReloadSupported is used for this
   purpose. Other apis do not apply, and should not be registered.
   '''
   def __init__( self, openflowConfig ):
      self.openflowConfig_ = openflowConfig
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = None, None
      if self.openflowConfig_ and self.openflowConfig_.enabled:
         blockingList = [ ReloadHitlessBlockingReason( reason='openFlowEnabled' ) ]
      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'OpenFlow'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      openflowConfig = mg.mount( 'openflow/config', 'OpenFlow::Config', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler(
         featureName,
         OpenFlowAsuPStoreEventHandler( openflowConfig ) )
   else:
      ctx.registerAsuPStoreEventHandler(
         featureName,
         OpenFlowAsuPStoreEventHandler( None ) )
      
