#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
import SharedMem
import Smash
from collections import defaultdict

class NatPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, dynamicConnectionStatus ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.dynamicConnectionStatus = dynamicConnectionStatus

   def getConnectionInfo( self ):
      def _createConnection():
         rv = {}
         rv[ 'globalAddress' ] = ''
         rv[ 'connMark' ] = ''
         rv[ 'flags' ] = ''
         rv[ 'target' ] = ''
         rv[ 'fullCone' ] = ''
         rv[ 'addrOnly' ] = ''
         rv[ 'twiceNat' ] = ''
         return rv

      def _setGlobalAddress( key, globalAddress ):
         dynamicConnection[ key ][ 'globalAddress' ] = globalAddress

      def _setConnMark( key, connMark ):
         dynamicConnection[ key ][ 'connMark' ] = connMark

      def _setFlags( key, flags ):
         dynamicConnection[ key ][ 'flags' ] = flags

      def _setTarget( key, target ):
         dynamicConnection[ key ][ 'target' ] = target

      def _setFullCone( key, fullCone ):
         dynamicConnection[ key ][ 'fullCone' ] = fullCone

      def _setAddrOnly( key, addrOnly ):
         dynamicConnection[ key ][ 'addrOnly' ] = addrOnly

      def _setTwiceNat( key, twiceNat ):
         dynamicConnection[ key ][ 'twiceNat' ] = twiceNat

      dynamicConnection = defaultdict( _createConnection )

      for k, status in self.dynamicConnectionStatus.dynamicConnection.iteritems():
         key = k.natIntf + k.connTuple.stringValue()
         _setGlobalAddress( key, status.globalAddress.stringValue() )
         _setConnMark( key, status.connMark )
         _setFlags( key, status.flags )
         _setTarget( key, status.target() )
         _setFullCone( key, status.fullCone() )
         _setAddrOnly( key, status.addrOnly() )
         _setTwiceNat( key, status.twiceNat() )

      return dynamicConnection

   def save( self, pStoreIO ):
      pStoreIO.set( 'dynamicConnections', self.getConnectionInfo() )

   def getSupportedKeys( self ):
      return [ 'dynamicConnections' ]

   def getKeys( self ):
      return [ 'dynamicConnections' ]


def Plugin( ctx ):
   featureName = 'Nat'

   if ctx.opcode() == 'GetSupportedKeys':
      dynamicConnectionStatus = None
   else:

      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()

      # We are using "shadow" instead of "reader" to avoid mismatch with NatCli.py
      smashEm = SharedMem.entityManager( sysdbEm=entityManager )
      mountInfo = Smash.mountInfo( 'shadow' )

      dynamicConnectionStatus = smashEm.doMount( "ip/nat/status/dynamicConnection",
               "Ip::Nat::DynamicConnectionStatus", mountInfo )

      mg.close( blocking=True )

   ctx.registerAsuPStoreEventHandler(
         featureName,
         NatPStoreEventHandler( dynamicConnectionStatus ) )
