# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

class IsisAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''We should warn on ASU2 hitless reload if there is at least one ISIS instance
   configured on switch but graceful restart is not enabled. AsuPStorePlugin's
   hitlessReloadSupported is used for this purpose. Other apis do not apply, and
   should not be registered.
   '''
   def __init__( self, isisConfig ):
      self.isisConfig = isisConfig
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = None, None
      for i in self.isisConfig.instanceConfig:
         if not self.isisConfig.instanceConfig[ i ].shutdown and \
            not self.isisConfig.instanceConfig[i].gracefulRestart:
            warningList = [ ReloadHitlessWarningReason( reason="isisNoGrace" ) ]
            break
      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'Isis'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      isisConfig = mg.mount( 'routing/isis/config', 'Routing::Isis::Config', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IsisAsuPStoreEventHandler( isisConfig ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IsisAsuPStoreEventHandler( None ) )

