#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

__defaultTraceHandle__ = Tracing.Handle( "IgmpSnoopingAsu" )
t0 = __defaultTraceHandle__.trace0

class IgmpSnoopingAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   
   def __init__( self, status ):
      self.status_ = status
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      vlanStatus = self.status_.vlanStatus
      # Check for the existence of a querier
      for vlanId in vlanStatus.keys():
         if vlanStatus[vlanId].useVlanFloodset == False:
            warningList.append( ReloadHitlessWarningReason(
                                reason='igmpSnoopingEnabled' ) )
            break

      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'IgmpSnooping'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      status = mg.mount( 'bridging/igmpsnooping/forwarding/status',
                         'Bridging::IgmpSnooping::Status', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IgmpSnoopingAsuPStoreEventHandler(
                                         status ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IgmpSnoopingAsuPStoreEventHandler( None ) )
      
