#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, AsuPStore
import Tracing

t0 = Tracing.trace0

# Refer FeatureStore in Asu/AsuTestType.tac for store fields.
class EbraPStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, bridgingConfig, subIntfConfigDir ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.bridgingConfig_ = bridgingConfig
      self.subIntfConfigDir_ = subIntfConfigDir

   def storeIntfIdToVlanIdCol( self ):
      pyColDir = {}
      config = self.bridgingConfig_
      for intf in config.switchIntfConfig.keys():
         sic = config.switchIntfConfig[ intf ]
         if sic.switchportMode == 'routed' and sic.nativeVlan:
            pyColDir[ intf ] = sic.nativeVlan 
      assert len( pyColDir.values() ) == len( set( pyColDir.values() ) )
      return pyColDir

   def bridgeMacAddr( self ):
      return self.bridgingConfig_.bridgeMacAddr

   def subIntfToEncapVlan( self ):
      rv = {}
      for name, subIntfConfig in self.subIntfConfigDir_.intfConfig.iteritems():
         rv[ name ] = subIntfConfig.dot1qEncap.outerTag
      return rv

   def save( self, pStoreIO ):
      # Save TAC collection as dictionary in string format
      pyCol = self.storeIntfIdToVlanIdCol()
      pStoreIO.set( 'intfNameToVlanId', pyCol )
      pStoreIO.set( 'bridgeMacAddr', self.bridgeMacAddr() )
      pStoreIO.set( 'subIntfNameToEncapVlanId', self.subIntfToEncapVlan() )

   def getSupportedKeys( self ):
      return [ 'intfNameToVlanId', 'bridgeMacAddr' ]

   def getKeys( self ):
      return [ 'intfNameToVlanId', 'bridgeMacAddr' ]

def Plugin( ctx ):

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler( 'Ebra',
                                         EbraPStoreEventHandler( None, None ) )
      return
   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()
   bridingConfig = mg.mount( 'bridging/config', 'Bridging::Config', 'r' )
   subintfConfigDir = mg.mount( 'interface/config/subintf',
                                'Interface::SubIntfConfigDir', 'r' )
   t0( "asuStore: ", bridingConfig )
   mg.close( blocking=True )
   ctx.registerAsuPStoreEventHandler(
      'Ebra', EbraPStoreEventHandler( bridingConfig, subintfConfigDir ) )
