#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class DirectFlowPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When directflow is configured,
   this configuration will block ASU2 hitless reload.
   '''
   def __init__( self, directflowHwConfig ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.directflowHwConfig_ = directflowHwConfig

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.directflowHwConfig_ and self.directflowHwConfig_.enabled:
         blockingList.append( ReloadHitlessBlockingReason( 
                                 reason='directFlowEnabled' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'DirectFlow'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      directflowHwConfig = mg.mount( "openflow/directflowhwconfig",
            "OpenFlowTable::DirectFlowHwConfig", "rS" )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler(
            featureName,
            DirectFlowPStoreEventHandler( directflowHwConfig ) ) 
   else:
      ctx.registerAsuPStoreEventHandler(
            featureName,
            DirectFlowPStoreEventHandler( None ) ) 
