#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# N.B. If you edit this file you must regenerate and replace
# the associated AsuPatch patch RPM. For more information see
# /src/AsuPatch/packages/README.

import AsuPStore
import Tracing

t0 = Tracing.trace0

class AleMroutePStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, af, mfibHwStatus ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.af_ =  af
      self.mfibHwStatus_ = mfibHwStatus

   def _pStoreKeyName( self ):
      return 'mfibSgEntries' if self.af_ == 'ipv4' else 'mfib6SgEntries'

   def storeMfibHwStatus( self ):
      pstoreInfo = {}
      vrfStatus = self.mfibHwStatus_.vrfStatus
      for vrf in vrfStatus.keys():
         rs = vrfStatus[ vrf ].route
         for sg in rs.keys():
            if vrf not in pstoreInfo:
               pstoreInfo[ vrf ] = []
            entry = [ str( sg.s ), str( sg.g ), rs[ sg ].acceptingIntfId ]
            pstoreInfo[ vrf ].append( entry )
      return pstoreInfo

   def save( self, pStoreIO ):
      info = self.storeMfibHwStatus()
      pStoreKey = self._pStoreKeyName()
      pStoreIO.set( pStoreKey, info )

   def getSupportedKeys( self ):
      return [ self._pStoreKeyName() ]

   def getKeys( self ):
      return [ self._pStoreKeyName() ]

def Plugin( ctx ):

   featureName4 = "AleMroute"
   featureName6 = "AleMroute6"
   t0( "opcode is", ctx.opcode() )
   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler( featureName4,
            AleMroutePStoreEventHandler( 'ipv4', None ) )
      ctx.registerAsuPStoreEventHandler( featureName6,
            AleMroutePStoreEventHandler( 'ipv6', None ) )
      return
   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()
   hwStatus = mg.mount( 'routing/hardware/multicast/status',
                        'Routing::Multicast::Fib::Hardware::Status',
                        'r' )
   hw6Status = mg.mount( 'routing6/hardware/multicast/status',
                        'Routing::Multicast::Fib::Hardware::Status',
                        'r' )
   mg.close( blocking=True )
   ctx.registerAsuPStoreEventHandler(
      featureName4, AleMroutePStoreEventHandler( 'ipv4', hwStatus ) )
   ctx.registerAsuPStoreEventHandler(
      featureName6, AleMroutePStoreEventHandler( 'ipv6', hw6Status ) )
