#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import AsuPStore
import Tracing
from collections import defaultdict
from Ethernet import convertMacAddrCanonicalToDisplay

__defaultTraceHandle__ = Tracing.Handle( "AleMacAddrAsu" )
t0 = Tracing.trace0

class AleMacAddrPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''
   Save all the local dynamic macs in PStore during ASU reload.
   '''
   def __init__( self, bridgingStatus ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.bridgingStatus_ = bridgingStatus

   def hitlessReloadSupported( self ):
      return ( [], [] )

   def save( self, pStoreIO ):
      t0( 'Saving bridgingStatus asu state' )
      pStoreIO.set( 'fdbStatus', self.getFdbStatusInfo() )

   def getSupportedKeys( self ):
      return [ 'fdbStatus' ]

   def getKeys( self ):
      return [ 'fdbStatus' ]

   def getFdbStatusInfo( self ):
      fdbStatus = defaultdict( list )
      for fid in self.bridgingStatus_.fdbStatus:
         learnedHost = self.bridgingStatus_.fdbStatus[ fid ].learnedHost
         for lh in learnedHost.values():
            if lh.entryType == 'learnedDynamicMac':
               t0( 'Saving dynamic learned host', lh )
               fdbStatus[ fid ].append(
                     ( convertMacAddrCanonicalToDisplay( lh.address ), lh.intf ) )
      return fdbStatus

def Plugin( ctx ):
   featureName = 'AleMacAddrSm'
   if ctx.opcode() == 'Store':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      bridgingStatus = mg.mount( 'bridging/status',
            'Bridging::Status', 'r' )
      mg.close( blocking=True )
   else:
      bridgingStatus = None

   ctx.registerAsuPStoreEventHandler(
         featureName,
         AleMacAddrPStoreEventHandler( bridgingStatus ) )
