# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class TableImpl( dict ):
   def __init__( self, rowType, copyOnRead=None, 
                 copyOnInsertion=None,
                 **kargs ):
      """genOid = True says to ignore the optional genOid arg to rowIs and 
      always generate an oid for new rows.  genOid = False says to depend
      on the arg passed to rowIs().
      copyOnRead defaults to True, and copyOnInsertion to False.
      If you specify only one of them, the other takes the opposite value.
      You can specify both specifically, if you want to avoid this behavior.
      Note that rows returned by iterators are *not* copies.  Be careful
      not to modify them --- you can destroy the integrity of the tables"""
      
      dict.__init__( self )
      self.copyOnRead_ = bool( copyOnRead )
      self.copyOnInsertion_ = bool( copyOnInsertion )
      if copyOnRead is None:
         if copyOnInsertion is None: # no defaults were specified at all
            self.copyOnRead_ = True
         else: # negate copyOnInsertion
            self.copyOnRead_ = not copyOnInsertion
      if copyOnInsertion is None:
         if copyOnRead is None: # no defaults were specified at all
            self.copyOnInsertion_ = False
         else: # negate copyOnRead
            self.copyOnInsertion_ = not copyOnRead
      self.rowFormatter_ = kargs.get( "rowFormatter", None )
      self.rowType_ = rowType

   def __missing__( self, key ):
      return None

   def rows( self ):
      return len( self )

   def row( self, key ):
      tableRow = self.get( key )
      if self.copyOnRead_ and tableRow:
         tableRow = tableRow.__class__( row=tableRow )
      return tableRow
   
   def rowIs( self, row ):
      if row.rowType() != self.rowType_:
         raise TypeError, "passed type %d is not equal to expected type %d" %  \
                          ( row.rowType(), self.rowType_ )
      if self.copyOnInsertion_:
         rowCopy = row.__class__( row=row )
      else:
         rowCopy = row  
      super( TableImpl, self ).__setitem__( rowCopy,  rowCopy )
      return rowCopy

   def rowDel( self, row ):
      existingRow = self[ row ]
      if( existingRow is not  None ):
         super( TableImpl, self).__delitem__( existingRow )

   def clear( self ):
      super(TableImpl, self).clear()

   def listRows( self, rowFormatter=None ):
      print "rows:", self.rows() 
      for _k, r in self.iteritems():
         if rowFormatter:
            print rowFormatter( r )
         elif self.rowFormatter_:
            print self.rowFormatter_( r )
         else:
            print r.toString()

   def __setitem__( self, key, row ):
      assert( key == row )
      self.rowIs( row )
   def __delitem__( self, key ):
      self.rowDel( key )
   def __iter__( self ):
      # need to return only values, because when a row is replaced, the old
      # row stored as the key is *not* replaced
      sortedKeys = sorted( super( TableImpl, self ).itervalues() )
      return iter( sortedKeys )
   def iteritems( self ):
      for v in iter( self ):
         yield( ( v, v ) )
   def iterkeys( self ):
      return iter( self )
   def itervalues( self ):
      return iter( self )
   def items( self ):
      return list( self.iteritems() )
   def keys( self ):
      return list( iter( self ))
   def values( self ):
      return list( iter( self ))
   def rowType( self ):
      return self.rowType_

