# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# FIXME -- does this have any copyright/license issues?

# copied from:
#    http://stackoverflow.com/questions/1205722/
#         how-do-i-get-monotonic-time-durations-in-python

# value returned is monotonic time in seconds as a floating
# point value.  Precision is platform dependent.

__all__ = ["monotonic_time"]

import ctypes, os

CLOCK_MONOTONIC_RAW = 4 # see <linux/time.h>

class timespec(ctypes.Structure):
   _fields_ = [
      ('tv_sec', ctypes.c_long),
      ('tv_nsec', ctypes.c_long)
  ]

librt = ctypes.CDLL('librt.so.1', use_errno=True)
clock_gettime = librt.clock_gettime
clock_gettime.argtypes = [ctypes.c_int, ctypes.POINTER(timespec)]

def monotonic_time():
   t = timespec()
   if clock_gettime(CLOCK_MONOTONIC_RAW , ctypes.pointer(t)) != 0:
      errno_ = ctypes.get_errno()
      raise OSError(errno_, os.strerror(errno_))
   return t.tv_sec + t.tv_nsec * 1e-9

if __name__ == "__main__":
   print monotonic_time()
