
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from arTable.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class arTable( BaseRow ):

   rowType_ = 2


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::arTable"

   @staticmethod
   def protRowType( ):
     return arTable.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( arTable.rowType_ == 0 ) or
         ( arTable.rowType_ == rowTypeId )):
       arTable.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, arTable.rowType_,
                                 arTable.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(arTable, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(arTable, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "arTable" )
      else:
         super(arTable, self).__init__( length =  33 )

   def oid(self):
      return self.extU32( 4 )
   def tablePath(self):
      return self.strFrom( 8 )
   def typeName(self):
      return self.strFrom( 12 )
   def tableType(self):
      return self.extU8( 16 )
   def desiredFlags(self):
      return self.extU16( 17 )
   def flags(self):
      return self.extU16( 19 )
   def owner(self):
      return self.strFrom( 21 )
   def paramNames(self):
      return self.varAryFrom( 25, ArrowTypes.ar_string )
   def paramValues(self):
      return self.varAryFrom( 29, ArrowTypes.ar_string )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def tablePathIs( self, v ):
      return self.insertString( 8, v )
   def typeNameIs( self, v ):
      return self.insertString( 12, v )
   def tableTypeIs( self, v ):
      return self.insertU8( 16, v )
   def desiredFlagsIs( self, v ):
      return self.insertU16( 17, v )
   def flagsIs( self, v ):
      return self.insertU16( 19, v )
   def ownerIs( self, v ):
      return self.insertString( 21, v )
   def paramNamesIs( self, v ):
      return self.insertVarAry( 25, v, ArrowTypes.ar_string )
   def paramValuesIs( self, v ):
      return self.insertVarAry( 29, v, ArrowTypes.ar_string )



   def __eq__( self, o ):
      return self.tablePath() == o.tablePath()

   def __hash__( self ):
      l = ( self.tablePath() )
      return hash( l )

   def __lt__( self, o ):
      if self.tablePath() < o.tablePath():
         return True
      if self.tablePath() > o.tablePath():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.tablePath() == o.tablePath() and \
             self.typeName() == o.typeName() and \
             self.tableType() == o.tableType() and \
             self.desiredFlags() == o.desiredFlags() and \
             self.flags() == o.flags() and \
             self.owner() == o.owner() and \
             self.paramNames() == o.paramNames() and \
             self.paramValues() == o.paramValues()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'tablePath = \"%s\"' % (self.tablePath()) + ", "
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'tableType = %u' % (self.tableType()) + ", "
      v = v + 'desiredFlags = %u' % (self.desiredFlags()) + ", "
      v = v + 'flags = %u' % (self.flags()) + ", "
      v = v + 'owner = \"%s\"' % (self.owner()) + ", "
      v = v + 'paramNames = [ %s ]' % (self.arrayToString(self.paramNames(), '\"%s\"')) + ", "
      v = v + 'paramValues = [ %s ]' % (self.arrayToString(self.paramValues(), '\"%s\"'))
      return v
