
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from arDefault.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class arDefault( BaseRow ):

   rowType_ = 5


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::arDefault"

   @staticmethod
   def protRowType( ):
     return arDefault.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( arDefault.rowType_ == 0 ) or
         ( arDefault.rowType_ == rowTypeId )):
       arDefault.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, arDefault.rowType_,
                                 arDefault.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(arDefault, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(arDefault, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "arDefault" )
      else:
         super(arDefault, self).__init__( length =  18 )

   def typeName(self):
      return self.strFrom( 4 )
   def idx(self):
      return self.extU16( 8 )
   def code(self):
      return self.strFrom( 10 )
   def src(self):
      return self.strFrom( 14 )

   def typeNameIs( self, v ):
      return self.insertString( 4, v )
   def idxIs( self, v ):
      return self.insertU16( 8, v )
   def codeIs( self, v ):
      return self.insertString( 10, v )
   def srcIs( self, v ):
      return self.insertString( 14, v )



   def __eq__( self, o ):
      return self.typeName() == o.typeName() and \
             self.idx() == o.idx()

   def __hash__( self ):
      l = ( self.typeName(), self.idx() )
      return hash( l )

   def __lt__( self, o ):
      if self.typeName() < o.typeName():
         return True
      if self.typeName() > o.typeName():
         return False
      if self.idx() < o.idx():
         return True
      if self.idx() > o.idx():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.typeName() == o.typeName() and \
             self.idx() == o.idx() and \
             self.code() == o.code() and \
             self.src() == o.src()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'idx = %u' % (self.idx()) + ", "
      v = v + 'code = \"%s\"' % (self.code()) + ", "
      v = v + 'src = \"%s\"' % (self.src())
      return v
