
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from arConstraint.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class arConstraint( BaseRow ):

   rowType_ = 4


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::arConstraint"

   @staticmethod
   def protRowType( ):
     return arConstraint.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( arConstraint.rowType_ == 0 ) or
         ( arConstraint.rowType_ == rowTypeId )):
       arConstraint.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, arConstraint.rowType_,
                                 arConstraint.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(arConstraint, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(arConstraint, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "arConstraint" )
      else:
         super(arConstraint, self).__init__( length =  33 )

   def typeName(self):
      return self.strFrom( 4 )
   def idx(self):
      return self.extU16( 8 )
   def conName(self):
      return self.strFrom( 10 )
   def idxType(self):
      return self.extU8( 14 )
   def indid(self):
      return self.extU32( 15 )
   def frelid(self):
      return self.extU32( 19 )
   def keyCols(self):
      return self.aryFrom( 23, ArrowTypes.ar_uint32 )
   def keyOrder(self):
      return self.extU16( 27 )
   def src(self):
      return self.strFrom( 29 )

   def typeNameIs( self, v ):
      return self.insertString( 4, v )
   def idxIs( self, v ):
      return self.insertU16( 8, v )
   def conNameIs( self, v ):
      return self.insertString( 10, v )
   def idxTypeIs( self, v ):
      return self.insertU8( 14, v )
   def indidIs( self, v ):
      return self.insertU32( 15, v )
   def frelidIs( self, v ):
      return self.insertU32( 19, v )
   def keyColsIs( self, v ):
      return self.insertFixedAry( 23, v, ArrowTypes.ar_uint32 )
   def keyOrderIs( self, v ):
      return self.insertU16( 27, v )
   def srcIs( self, v ):
      return self.insertString( 29, v )



   def __eq__( self, o ):
      return self.typeName() == o.typeName() and \
             self.idx() == o.idx()

   def __hash__( self ):
      l = ( self.typeName(), self.idx() )
      return hash( l )

   def __lt__( self, o ):
      if self.typeName() < o.typeName():
         return True
      if self.typeName() > o.typeName():
         return False
      if self.idx() < o.idx():
         return True
      if self.idx() > o.idx():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.typeName() == o.typeName() and \
             self.idx() == o.idx() and \
             self.conName() == o.conName() and \
             self.idxType() == o.idxType() and \
             self.indid() == o.indid() and \
             self.frelid() == o.frelid() and \
             self.keyCols() == o.keyCols() and \
             self.keyOrder() == o.keyOrder() and \
             self.src() == o.src()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'idx = %u' % (self.idx()) + ", "
      v = v + 'conName = \"%s\"' % (self.conName()) + ", "
      v = v + 'idxType = %u' % (self.idxType()) + ", "
      v = v + 'indid = %u' % (self.indid()) + ", "
      v = v + 'frelid = %u' % (self.frelid()) + ", "
      v = v + 'keyCols = [ %s ]' % (self.arrayToString(self.keyCols(), '%u')) + ", "
      v = v + 'keyOrder = %u' % (self.keyOrder()) + ", "
      v = v + 'src = \"%s\"' % (self.src())
      return v
