
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from arColumn.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class arColumn( BaseRow ):

   rowType_ = 3


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::arColumn"

   @staticmethod
   def protRowType( ):
     return arColumn.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( arColumn.rowType_ == 0 ) or
         ( arColumn.rowType_ == rowTypeId )):
       arColumn.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, arColumn.rowType_,
                                 arColumn.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(arColumn, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(arColumn, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "arColumn" )
      else:
         super(arColumn, self).__init__( length =  32 )

   def typeName(self):
      return self.strFrom( 4 )
   def colName(self):
      return self.strFrom( 8 )
   def arType(self):
      return self.extU16( 12 )
   def structType(self):
      return self.extU32( 14 )
   def len(self):
      return self.extU16( 18 )
   def num(self):
      return self.extU16( 20 )
   def isArray(self):
      return self.extBool( 22 )
   def elts(self):
      return self.extU16( 23 )
   def offset(self):
      return self.extU16( 25 )
   def nullable(self):
      return self.extBool( 27 )
   def defaultvalue(self):
      return self.strFrom( 28 )

   def typeNameIs( self, v ):
      return self.insertString( 4, v )
   def colNameIs( self, v ):
      return self.insertString( 8, v )
   def arTypeIs( self, v ):
      return self.insertU16( 12, v )
   def structTypeIs( self, v ):
      return self.insertU32( 14, v )
   def lenIs( self, v ):
      return self.insertU16( 18, v )
   def numIs( self, v ):
      return self.insertU16( 20, v )
   def isArrayIs( self, v ):
      return self.insertBool( 22, v )
   def eltsIs( self, v ):
      return self.insertU16( 23, v )
   def offsetIs( self, v ):
      return self.insertU16( 25, v )
   def nullableIs( self, v ):
      return self.insertBool( 27, v )
   def defaultvalueIs( self, v ):
      return self.insertString( 28, v )



   def __eq__( self, o ):
      return self.typeName() == o.typeName() and \
             self.num() == o.num()

   def __hash__( self ):
      l = ( self.typeName(), self.num() )
      return hash( l )

   def __lt__( self, o ):
      if self.typeName() < o.typeName():
         return True
      if self.typeName() > o.typeName():
         return False
      if self.num() < o.num():
         return True
      if self.num() > o.num():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.typeName() == o.typeName() and \
             self.colName() == o.colName() and \
             self.arType() == o.arType() and \
             self.structType() == o.structType() and \
             self.len() == o.len() and \
             self.num() == o.num() and \
             self.isArray() == o.isArray() and \
             self.elts() == o.elts() and \
             self.offset() == o.offset() and \
             self.nullable() == o.nullable() and \
             self.defaultvalue() == o.defaultvalue()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'colName = \"%s\"' % (self.colName()) + ", "
      v = v + 'arType = %u' % (self.arType()) + ", "
      v = v + 'structType = %u' % (self.structType()) + ", "
      v = v + 'len = %u' % (self.len()) + ", "
      v = v + 'num = %u' % (self.num()) + ", "
      v = v + 'isArray = %s' % (self.formatBool(self.isArray())) + ", "
      v = v + 'elts = %u' % (self.elts()) + ", "
      v = v + 'offset = %u' % (self.offset()) + ", "
      v = v + 'nullable = %s' % (self.formatBool(self.nullable())) + ", "
      v = v + 'defaultvalue = \"%s\"' % (self.defaultvalue())
      return v
