
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from arClass.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class arClass( BaseRow ):

   rowType_ = 1


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::arClass"

   @staticmethod
   def protRowType( ):
     return arClass.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( arClass.rowType_ == 0 ) or
         ( arClass.rowType_ == rowTypeId )):
       arClass.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, arClass.rowType_,
                                 arClass.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(arClass, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(arClass, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "arClass" )
      else:
         super(arClass, self).__init__( length =  33 )

   def oid(self):
      return self.extU32( 4 )
   def typeName(self):
      return self.strFrom( 8 )
   def nature(self):
      return self.extU16( 12 )
   def rowLen(self):
      return self.extU16( 14 )
   def rows(self):
      return self.extU32( 16 )
   def numCols(self):
      return self.extU16( 20 )
   def checks(self):
      return self.extU16( 22 )
   def numIndexes(self):
      return self.extU8( 24 )
   def src(self):
      return self.strFrom( 25 )
   def sig(self):
      return self.strFrom( 29 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def typeNameIs( self, v ):
      return self.insertString( 8, v )
   def natureIs( self, v ):
      return self.insertU16( 12, v )
   def rowLenIs( self, v ):
      return self.insertU16( 14, v )
   def rowsIs( self, v ):
      return self.insertU32( 16, v )
   def numColsIs( self, v ):
      return self.insertU16( 20, v )
   def checksIs( self, v ):
      return self.insertU16( 22, v )
   def numIndexesIs( self, v ):
      return self.insertU8( 24, v )
   def srcIs( self, v ):
      return self.insertString( 25, v )
   def sigIs( self, v ):
      return self.insertString( 29, v )



   def __eq__( self, o ):
      return self.typeName() == o.typeName()

   def __hash__( self ):
      l = ( self.typeName() )
      return hash( l )

   def __lt__( self, o ):
      if self.typeName() < o.typeName():
         return True
      if self.typeName() > o.typeName():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.typeName() == o.typeName() and \
             self.nature() == o.nature() and \
             self.rowLen() == o.rowLen() and \
             self.rows() == o.rows() and \
             self.numCols() == o.numCols() and \
             self.checks() == o.checks() and \
             self.numIndexes() == o.numIndexes() and \
             self.src() == o.src() and \
             self.sig() == o.sig()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'nature = %u' % (self.nature()) + ", "
      v = v + 'rowLen = %u' % (self.rowLen()) + ", "
      v = v + 'rows = %u' % (self.rows()) + ", "
      v = v + 'numCols = %u' % (self.numCols()) + ", "
      v = v + 'checks = %u' % (self.checks()) + ", "
      v = v + 'numIndexes = %u' % (self.numIndexes()) + ", "
      v = v + 'src = \"%s\"' % (self.src()) + ", "
      v = v + 'sig = \"%s\"' % (self.sig())
      return v
