
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from SystemDescription.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class SystemDescription( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arMetadata::SystemDescription"

   @staticmethod
   def protRowType( ):
     return SystemDescription.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( SystemDescription.rowType_ == 0 ) or
         ( SystemDescription.rowType_ == rowTypeId )):
       SystemDescription.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, SystemDescription.rowType_,
                                 SystemDescription.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(SystemDescription, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(SystemDescription, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "SystemDescription" )
      else:
         super(SystemDescription, self).__init__( length =  36 )

   def oid(self):
      return self.extU32( 4 )
   def sysName(self):
      return self.strFrom( 8 )
   def agentName(self):
      return self.strFrom( 12 )
   def connType(self):
      return self.extU32( 16 )
   def connection_id(self):
      return self.strFrom( 20 )
   def dbVersion(self):
      return self.extU32( 24 )
   def protoVersion(self):
      return self.extU32( 28 )
   def properties(self):
      return self.extU16( 32 )
   def clientDefaultProperties(self):
      return self.extU16( 34 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def sysNameIs( self, v ):
      return self.insertString( 8, v )
   def agentNameIs( self, v ):
      return self.insertString( 12, v )
   def connTypeIs( self, v ):
      return self.insertU32( 16, v )
   def connection_idIs( self, v ):
      return self.insertString( 20, v )
   def dbVersionIs( self, v ):
      return self.insertU32( 24, v )
   def protoVersionIs( self, v ):
      return self.insertU32( 28, v )
   def propertiesIs( self, v ):
      return self.insertU16( 32, v )
   def clientDefaultPropertiesIs( self, v ):
      return self.insertU16( 34, v )



   def __eq__( self, o ):
      return self.sysName() == o.sysName() and \
             self.agentName() == o.agentName() and \
             self.connection_id() == o.connection_id()

   def __hash__( self ):
      l = ( self.sysName(), self.agentName(), self.connection_id() )
      return hash( l )

   def __lt__( self, o ):
      if self.sysName() < o.sysName():
         return True
      if self.sysName() > o.sysName():
         return False
      if self.agentName() < o.agentName():
         return True
      if self.agentName() > o.agentName():
         return False
      if self.connection_id() < o.connection_id():
         return True
      if self.connection_id() > o.connection_id():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.sysName() == o.sysName() and \
             self.agentName() == o.agentName() and \
             self.connType() == o.connType() and \
             self.connection_id() == o.connection_id() and \
             self.dbVersion() == o.dbVersion() and \
             self.protoVersion() == o.protoVersion() and \
             self.properties() == o.properties() and \
             self.clientDefaultProperties() == o.clientDefaultProperties()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'sysName = \"%s\"' % (self.sysName()) + ", "
      v = v + 'agentName = \"%s\"' % (self.agentName()) + ", "
      v = v + 'connType = %u' % (self.connType()) + ", "
      v = v + 'connection_id = \"%s\"' % (self.connection_id()) + ", "
      v = v + 'dbVersion = %u' % (self.dbVersion()) + ", "
      v = v + 'protoVersion = %u' % (self.protoVersion()) + ", "
      v = v + 'properties = %u' % (self.properties()) + ", "
      v = v + 'clientDefaultProperties = %u' % (self.clientDefaultProperties())
      return v
