
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from table_instance.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class table_instance( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::table_instance"

   @staticmethod
   def protRowType( ):
     return table_instance.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( table_instance.rowType_ == 0 ) or
         ( table_instance.rowType_ == rowTypeId )):
       table_instance.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, table_instance.rowType_,
                                 table_instance.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(table_instance, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(table_instance, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "table_instance" )
      else:
         super(table_instance, self).__init__( length =  20 )

   def tableId(self):
      return self.extU32( 4 )
   def agent(self):
      return self.strFrom( 8 )
   def tableType(self):
      return self.extU8( 12 )
   def flags(self):
      return self.extU16( 13 )
   def status(self):
      return self.extBool( 15 )
   def reason(self):
      return self.strFrom( 16 )

   def tableIdIs( self, v ):
      return self.insertU32( 4, v )
   def agentIs( self, v ):
      return self.insertString( 8, v )
   def tableTypeIs( self, v ):
      return self.insertU8( 12, v )
   def flagsIs( self, v ):
      return self.insertU16( 13, v )
   def statusIs( self, v ):
      return self.insertBool( 15, v )
   def reasonIs( self, v ):
      return self.insertString( 16, v )



   def __eq__( self, o ):
      return self.tableId() == o.tableId() and \
             self.agent() == o.agent()

   def __hash__( self ):
      l = ( self.tableId(), self.agent() )
      return hash( l )

   def __lt__( self, o ):
      if self.tableId() < o.tableId():
         return True
      if self.tableId() > o.tableId():
         return False
      if self.agent() < o.agent():
         return True
      if self.agent() > o.agent():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.tableId() == o.tableId() and \
             self.agent() == o.agent() and \
             self.tableType() == o.tableType() and \
             self.flags() == o.flags() and \
             self.status() == o.status() and \
             self.reason() == o.reason()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'agent = \"%s\"' % (self.agent()) + ", "
      v = v + 'tableType = %u' % (self.tableType()) + ", "
      v = v + 'flags = %u' % (self.flags()) + ", "
      v = v + 'status = %s' % (self.formatBool(self.status())) + ", "
      v = v + 'reason = \"%s\"' % (self.reason())
      return v
