
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from subscription.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class subscription( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::subscription"

   @staticmethod
   def protRowType( ):
     return subscription.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( subscription.rowType_ == 0 ) or
         ( subscription.rowType_ == rowTypeId )):
       subscription.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, subscription.rowType_,
                                 subscription.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(subscription, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(subscription, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "subscription" )
      else:
         super(subscription, self).__init__( length =  41 )

   def oid(self):
      return self.extU32( 4 )
   def system_description(self):
      return self.extU32( 8 )
   def connection_id(self):
      return self.extU32( 12 )
   def tableId(self):
      return self.extU32( 16 )
   def writer(self):
      return self.extBool( 20 )
   def features(self):
      return self.extU32( 21 )
   def typeName(self):
      return self.strFrom( 25 )
   def type_signature(self):
      return self.strFrom( 29 )
   def ptime(self):
      return self.extU64( 33 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def system_descriptionIs( self, v ):
      return self.insertU32( 8, v )
   def connection_idIs( self, v ):
      return self.insertU32( 12, v )
   def tableIdIs( self, v ):
      return self.insertU32( 16, v )
   def writerIs( self, v ):
      return self.insertBool( 20, v )
   def featuresIs( self, v ):
      return self.insertU32( 21, v )
   def typeNameIs( self, v ):
      return self.insertString( 25, v )
   def type_signatureIs( self, v ):
      return self.insertString( 29, v )
   def ptimeIs( self, v ):
      return self.insertU64( 33, v )



   def __eq__( self, o ):
      return self.system_description() == o.system_description() and \
             self.tableId() == o.tableId()

   def __hash__( self ):
      l = ( self.system_description(), self.tableId() )
      return hash( l )

   def __lt__( self, o ):
      if self.system_description() < o.system_description():
         return True
      if self.system_description() > o.system_description():
         return False
      if self.tableId() < o.tableId():
         return True
      if self.tableId() > o.tableId():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.system_description() == o.system_description() and \
             self.connection_id() == o.connection_id() and \
             self.tableId() == o.tableId() and \
             self.writer() == o.writer() and \
             self.features() == o.features() and \
             self.typeName() == o.typeName() and \
             self.type_signature() == o.type_signature() and \
             self.ptime() == o.ptime()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'system_description = %u' % (self.system_description()) + ", "
      v = v + 'connection_id = %u' % (self.connection_id()) + ", "
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'writer = %s' % (self.formatBool(self.writer())) + ", "
      v = v + 'features = %u' % (self.features()) + ", "
      v = v + 'typeName = \"%s\"' % (self.typeName()) + ", "
      v = v + 'type_signature = \"%s\"' % (self.type_signature()) + ", "
      v = v + 'ptime = %u' % (self.ptime())
      return v
