
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from query_pub.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class query_pub( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::query_pub"

   @staticmethod
   def protRowType( ):
     return query_pub.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( query_pub.rowType_ == 0 ) or
         ( query_pub.rowType_ == rowTypeId )):
       query_pub.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, query_pub.rowType_,
                                 query_pub.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(query_pub, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(query_pub, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "query_pub" )
      else:
         super(query_pub, self).__init__( length =  26 )

   def qid(self):
      return self.extU32( 4 )
   def compiled(self):
      return self.extBool( 8 )
   def status(self):
      return self.extBool( 9 )
   def filepath(self):
      return self.strFrom( 10 )
   def queryName(self):
      return self.strFrom( 14 )
   def reason(self):
      return self.strFrom( 18 )
   def flags(self):
      return self.extU16( 22 )
   def nparams(self):
      return self.extU16( 24 )

   def qidIs( self, v ):
      return self.insertU32( 4, v )
   def compiledIs( self, v ):
      return self.insertBool( 8, v )
   def statusIs( self, v ):
      return self.insertBool( 9, v )
   def filepathIs( self, v ):
      return self.insertString( 10, v )
   def queryNameIs( self, v ):
      return self.insertString( 14, v )
   def reasonIs( self, v ):
      return self.insertString( 18, v )
   def flagsIs( self, v ):
      return self.insertU16( 22, v )
   def nparamsIs( self, v ):
      return self.insertU16( 24, v )



   def __eq__( self, o ):
      return self.qid() == o.qid()

   def __hash__( self ):
      l = ( self.qid() )
      return hash( l )

   def __lt__( self, o ):
      if self.qid() < o.qid():
         return True
      if self.qid() > o.qid():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qid() == o.qid() and \
             self.compiled() == o.compiled() and \
             self.status() == o.status() and \
             self.filepath() == o.filepath() and \
             self.queryName() == o.queryName() and \
             self.reason() == o.reason() and \
             self.flags() == o.flags() and \
             self.nparams() == o.nparams()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qid = %u' % (self.qid()) + ", "
      v = v + 'compiled = %s' % (self.formatBool(self.compiled())) + ", "
      v = v + 'status = %s' % (self.formatBool(self.status())) + ", "
      v = v + 'filepath = \"%s\"' % (self.filepath()) + ", "
      v = v + 'queryName = \"%s\"' % (self.queryName()) + ", "
      v = v + 'reason = \"%s\"' % (self.reason()) + ", "
      v = v + 'flags = %u' % (self.flags()) + ", "
      v = v + 'nparams = %u' % (self.nparams())
      return v
