
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from query_parameter.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class query_parameter( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::query_parameter"

   @staticmethod
   def protRowType( ):
     return query_parameter.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( query_parameter.rowType_ == 0 ) or
         ( query_parameter.rowType_ == rowTypeId )):
       query_parameter.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, query_parameter.rowType_,
                                 query_parameter.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(query_parameter, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(query_parameter, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "query_parameter" )
      else:
         super(query_parameter, self).__init__( length =  16 )

   def qiid(self):
      return self.extU32( 4 )
   def paramName(self):
      return self.strFrom( 8 )
   def paramValue(self):
      return self.strFrom( 12 )

   def qiidIs( self, v ):
      return self.insertU32( 4, v )
   def paramNameIs( self, v ):
      return self.insertString( 8, v )
   def paramValueIs( self, v ):
      return self.insertString( 12, v )



   def __eq__( self, o ):
      return self.qiid() == o.qiid() and \
             self.paramName() == o.paramName()

   def __hash__( self ):
      l = ( self.qiid(), self.paramName() )
      return hash( l )

   def __lt__( self, o ):
      if self.qiid() < o.qiid():
         return True
      if self.qiid() > o.qiid():
         return False
      if self.paramName() < o.paramName():
         return True
      if self.paramName() > o.paramName():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qiid() == o.qiid() and \
             self.paramName() == o.paramName() and \
             self.paramValue() == o.paramValue()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qiid = %u' % (self.qiid()) + ", "
      v = v + 'paramName = \"%s\"' % (self.paramName()) + ", "
      v = v + 'paramValue = \"%s\"' % (self.paramValue())
      return v
