
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from query_param_types.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class query_param_types( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::query_param_types"

   @staticmethod
   def protRowType( ):
     return query_param_types.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( query_param_types.rowType_ == 0 ) or
         ( query_param_types.rowType_ == rowTypeId )):
       query_param_types.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, query_param_types.rowType_,
                                 query_param_types.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(query_param_types, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(query_param_types, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "query_param_types" )
      else:
         super(query_param_types, self).__init__( length =  15 )

   def qid(self):
      return self.extU32( 4 )
   def idx(self):
      return self.extU16( 8 )
   def name(self):
      return self.strFrom( 10 )
   def direction(self):
      return self.extU8( 14 )

   def qidIs( self, v ):
      return self.insertU32( 4, v )
   def idxIs( self, v ):
      return self.insertU16( 8, v )
   def nameIs( self, v ):
      return self.insertString( 10, v )
   def directionIs( self, v ):
      return self.insertU8( 14, v )



   def __eq__( self, o ):
      return self.qid() == o.qid() and \
             self.idx() == o.idx()

   def __hash__( self ):
      l = ( self.qid(), self.idx() )
      return hash( l )

   def __lt__( self, o ):
      if self.qid() < o.qid():
         return True
      if self.qid() > o.qid():
         return False
      if self.idx() < o.idx():
         return True
      if self.idx() > o.idx():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qid() == o.qid() and \
             self.idx() == o.idx() and \
             self.name() == o.name() and \
             self.direction() == o.direction()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qid = %u' % (self.qid()) + ", "
      v = v + 'idx = %u' % (self.idx()) + ", "
      v = v + 'name = \"%s\"' % (self.name()) + ", "
      v = v + 'direction = %u' % (self.direction())
      return v
