
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from query_instance.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class query_instance( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::query_instance"

   @staticmethod
   def protRowType( ):
     return query_instance.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( query_instance.rowType_ == 0 ) or
         ( query_instance.rowType_ == rowTypeId )):
       query_instance.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, query_instance.rowType_,
                                 query_instance.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(query_instance, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(query_instance, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "query_instance" )
      else:
         super(query_instance, self).__init__( length =  32 )

   def oid(self):
      return self.extU32( 4 )
   def qid(self):
      return self.extU32( 8 )
   def outputPath(self):
      return self.strFrom( 12 )
   def dispatchTablePath(self):
      return self.strFrom( 16 )
   def agent(self):
      return self.strFrom( 20 )
   def system_description(self):
      return self.extU32( 24 )
   def standing(self):
      return self.extBool( 28 )
   def force(self):
      return self.extBool( 29 )
   def clientProperties(self):
      return self.extU16( 30 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def qidIs( self, v ):
      return self.insertU32( 8, v )
   def outputPathIs( self, v ):
      return self.insertString( 12, v )
   def dispatchTablePathIs( self, v ):
      return self.insertString( 16, v )
   def agentIs( self, v ):
      return self.insertString( 20, v )
   def system_descriptionIs( self, v ):
      return self.insertU32( 24, v )
   def standingIs( self, v ):
      return self.insertBool( 28, v )
   def forceIs( self, v ):
      return self.insertBool( 29, v )
   def clientPropertiesIs( self, v ):
      return self.insertU16( 30, v )



   def __eq__( self, o ):
      return self.outputPath() == o.outputPath()

   def __hash__( self ):
      l = ( self.outputPath() )
      return hash( l )

   def __lt__( self, o ):
      if self.outputPath() < o.outputPath():
         return True
      if self.outputPath() > o.outputPath():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.qid() == o.qid() and \
             self.outputPath() == o.outputPath() and \
             self.dispatchTablePath() == o.dispatchTablePath() and \
             self.agent() == o.agent() and \
             self.system_description() == o.system_description() and \
             self.standing() == o.standing() and \
             self.force() == o.force() and \
             self.clientProperties() == o.clientProperties()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'qid = %u' % (self.qid()) + ", "
      v = v + 'outputPath = \"%s\"' % (self.outputPath()) + ", "
      v = v + 'dispatchTablePath = \"%s\"' % (self.dispatchTablePath()) + ", "
      v = v + 'agent = \"%s\"' % (self.agent()) + ", "
      v = v + 'system_description = %u' % (self.system_description()) + ", "
      v = v + 'standing = %s' % (self.formatBool(self.standing())) + ", "
      v = v + 'force = %s' % (self.formatBool(self.force())) + ", "
      v = v + 'clientProperties = %u' % (self.clientProperties())
      return v
