
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from query.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class query( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::query"

   @staticmethod
   def protRowType( ):
     return query.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( query.rowType_ == 0 ) or
         ( query.rowType_ == rowTypeId )):
       query.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, query.rowType_,
                                 query.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(query, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(query, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "query" )
      else:
         super(query, self).__init__( length =  23 )

   def oid(self):
      return self.extU32( 4 )
   def name(self):
      return self.strFrom( 8 )
   def queryText(self):
      return self.strFrom( 12 )
   def outputType(self):
      return self.extU32( 16 )
   def standing(self):
      return self.extBool( 20 )
   def scrub(self):
      return self.extBool( 21 )
   def typesOnly(self):
      return self.extBool( 22 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def nameIs( self, v ):
      return self.insertString( 8, v )
   def queryTextIs( self, v ):
      return self.insertString( 12, v )
   def outputTypeIs( self, v ):
      return self.insertU32( 16, v )
   def standingIs( self, v ):
      return self.insertBool( 20, v )
   def scrubIs( self, v ):
      return self.insertBool( 21, v )
   def typesOnlyIs( self, v ):
      return self.insertBool( 22, v )



   def __eq__( self, o ):
      return self.queryText() == o.queryText() and \
             self.standing() == o.standing() and \
             self.scrub() == o.scrub()

   def __hash__( self ):
      l = ( self.queryText(), self.standing(), self.scrub() )
      return hash( l )

   def __lt__( self, o ):
      if self.queryText() < o.queryText():
         return True
      if self.queryText() > o.queryText():
         return False
      if self.standing() < o.standing():
         return True
      if self.standing() > o.standing():
         return False
      if self.scrub() < o.scrub():
         return True
      if self.scrub() > o.scrub():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.name() == o.name() and \
             self.queryText() == o.queryText() and \
             self.outputType() == o.outputType() and \
             self.standing() == o.standing() and \
             self.scrub() == o.scrub() and \
             self.typesOnly() == o.typesOnly()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'name = \"%s\"' % (self.name()) + ", "
      v = v + 'queryText = \"%s\"' % (self.queryText()) + ", "
      v = v + 'outputType = %u' % (self.outputType()) + ", "
      v = v + 'standing = %s' % (self.formatBool(self.standing())) + ", "
      v = v + 'scrub = %s' % (self.formatBool(self.scrub())) + ", "
      v = v + 'typesOnly = %s' % (self.formatBool(self.typesOnly()))
      return v
