
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from publication.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class publication( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::publication"

   @staticmethod
   def protRowType( ):
     return publication.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( publication.rowType_ == 0 ) or
         ( publication.rowType_ == rowTypeId )):
       publication.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, publication.rowType_,
                                 publication.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(publication, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(publication, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "publication" )
      else:
         super(publication, self).__init__( length =  41 )

   def subscription_id(self):
      return self.extU32( 4 )
   def view_id(self):
      return self.extU32( 8 )
   def connection_id(self):
      return self.extU32( 12 )
   def tableId(self):
      return self.extU32( 16 )
   def typeId(self):
      return self.extU32( 20 )
   def ptime(self):
      return self.extU64( 24 )
   def system_id(self):
      return self.extU32( 32 )
   def status(self):
      return self.extBool( 36 )
   def error(self):
      return self.strFrom( 37 )

   def subscription_idIs( self, v ):
      return self.insertU32( 4, v )
   def view_idIs( self, v ):
      return self.insertU32( 8, v )
   def connection_idIs( self, v ):
      return self.insertU32( 12, v )
   def tableIdIs( self, v ):
      return self.insertU32( 16, v )
   def typeIdIs( self, v ):
      return self.insertU32( 20, v )
   def ptimeIs( self, v ):
      return self.insertU64( 24, v )
   def system_idIs( self, v ):
      return self.insertU32( 32, v )
   def statusIs( self, v ):
      return self.insertBool( 36, v )
   def errorIs( self, v ):
      return self.insertString( 37, v )



   def __eq__( self, o ):
      return self.subscription_id() == o.subscription_id()

   def __hash__( self ):
      l = ( self.subscription_id() )
      return hash( l )

   def __lt__( self, o ):
      if self.subscription_id() < o.subscription_id():
         return True
      if self.subscription_id() > o.subscription_id():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.subscription_id() == o.subscription_id() and \
             self.view_id() == o.view_id() and \
             self.connection_id() == o.connection_id() and \
             self.tableId() == o.tableId() and \
             self.typeId() == o.typeId() and \
             self.ptime() == o.ptime() and \
             self.system_id() == o.system_id() and \
             self.status() == o.status() and \
             self.error() == o.error()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'subscription_id = %u' % (self.subscription_id()) + ", "
      v = v + 'view_id = %u' % (self.view_id()) + ", "
      v = v + 'connection_id = %u' % (self.connection_id()) + ", "
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'typeId = %u' % (self.typeId()) + ", "
      v = v + 'ptime = %u' % (self.ptime()) + ", "
      v = v + 'system_id = %u' % (self.system_id()) + ", "
      v = v + 'status = %s' % (self.formatBool(self.status())) + ", "
      v = v + 'error = \"%s\"' % (self.error())
      return v
