
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from client_instance.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class client_instance( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::client_instance"

   @staticmethod
   def protRowType( ):
     return client_instance.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( client_instance.rowType_ == 0 ) or
         ( client_instance.rowType_ == rowTypeId )):
       client_instance.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, client_instance.rowType_,
                                 client_instance.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(client_instance, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(client_instance, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "client_instance" )
      else:
         super(client_instance, self).__init__( length =  39 )

   def clientId(self):
      return self.extU32( 4 )
   def agent(self):
      return self.strFrom( 8 )
   def sysDesc(self):
      return self.extU32( 12 )
   def tableId(self):
      return self.extU32( 16 )
   def scheduled(self):
      return self.extBool( 20 )
   def threadId(self):
      return self.extU64( 21 )
   def nature(self):
      return self.extU8( 29 )
   def clientType(self):
      return self.extU8( 30 )
   def activityName(self):
      return self.strFrom( 31 )
   def internalName(self):
      return self.strFrom( 35 )

   def clientIdIs( self, v ):
      return self.insertU32( 4, v )
   def agentIs( self, v ):
      return self.insertString( 8, v )
   def sysDescIs( self, v ):
      return self.insertU32( 12, v )
   def tableIdIs( self, v ):
      return self.insertU32( 16, v )
   def scheduledIs( self, v ):
      return self.insertBool( 20, v )
   def threadIdIs( self, v ):
      return self.insertU64( 21, v )
   def natureIs( self, v ):
      return self.insertU8( 29, v )
   def clientTypeIs( self, v ):
      return self.insertU8( 30, v )
   def activityNameIs( self, v ):
      return self.insertString( 31, v )
   def internalNameIs( self, v ):
      return self.insertString( 35, v )



   def __eq__( self, o ):
      return self.clientId() == o.clientId() and \
             self.nature() == o.nature()

   def __hash__( self ):
      l = ( self.clientId(), self.nature() )
      return hash( l )

   def __lt__( self, o ):
      if self.clientId() < o.clientId():
         return True
      if self.clientId() > o.clientId():
         return False
      if self.nature() < o.nature():
         return True
      if self.nature() > o.nature():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.clientId() == o.clientId() and \
             self.agent() == o.agent() and \
             self.sysDesc() == o.sysDesc() and \
             self.tableId() == o.tableId() and \
             self.scheduled() == o.scheduled() and \
             self.threadId() == o.threadId() and \
             self.nature() == o.nature() and \
             self.clientType() == o.clientType() and \
             self.activityName() == o.activityName() and \
             self.internalName() == o.internalName()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'clientId = %u' % (self.clientId()) + ", "
      v = v + 'agent = \"%s\"' % (self.agent()) + ", "
      v = v + 'sysDesc = %u' % (self.sysDesc()) + ", "
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'scheduled = %s' % (self.formatBool(self.scheduled())) + ", "
      v = v + 'threadId = %u' % (self.threadId()) + ", "
      v = v + 'nature = %u' % (self.nature()) + ", "
      v = v + 'clientType = %u' % (self.clientType()) + ", "
      v = v + 'activityName = \"%s\"' % (self.activityName()) + ", "
      v = v + 'internalName = \"%s\"' % (self.internalName())
      return v
