
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from client.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class client( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::client"

   @staticmethod
   def protRowType( ):
     return client.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( client.rowType_ == 0 ) or
         ( client.rowType_ == rowTypeId )):
       client.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, client.rowType_,
                                 client.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(client, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(client, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "client" )
      else:
         super(client, self).__init__( length =  32 )

   def oid(self):
      return self.extU32( 4 )
   def clientId(self):
      return self.strFrom( 8 )
   def agent(self):
      return self.strFrom( 12 )
   def sysDesc(self):
      return self.extU32( 16 )
   def tid(self):
      return self.extU32( 20 )
   def scheduled(self):
      return self.extU8( 24 )
   def clientType(self):
      return self.extU8( 25 )
   def properties(self):
      return self.extU16( 26 )
   def activity(self):
      return self.strFrom( 28 )

   def oidIs( self, v ):
      return self.insertU32( 4, v )
   def clientIdIs( self, v ):
      return self.insertString( 8, v )
   def agentIs( self, v ):
      return self.insertString( 12, v )
   def sysDescIs( self, v ):
      return self.insertU32( 16, v )
   def tidIs( self, v ):
      return self.insertU32( 20, v )
   def scheduledIs( self, v ):
      return self.insertU8( 24, v )
   def clientTypeIs( self, v ):
      return self.insertU8( 25, v )
   def propertiesIs( self, v ):
      return self.insertU16( 26, v )
   def activityIs( self, v ):
      return self.insertString( 28, v )



   def __eq__( self, o ):
      return self.agent() == o.agent() and \
             self.clientId() == o.clientId()

   def __hash__( self ):
      l = ( self.agent(), self.clientId() )
      return hash( l )

   def __lt__( self, o ):
      if self.agent() < o.agent():
         return True
      if self.agent() > o.agent():
         return False
      if self.clientId() < o.clientId():
         return True
      if self.clientId() > o.clientId():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.oid() == o.oid() and \
             self.clientId() == o.clientId() and \
             self.agent() == o.agent() and \
             self.sysDesc() == o.sysDesc() and \
             self.tid() == o.tid() and \
             self.scheduled() == o.scheduled() and \
             self.clientType() == o.clientType() and \
             self.properties() == o.properties() and \
             self.activity() == o.activity()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'oid = %u' % (self.oid()) + ", "
      v = v + 'clientId = \"%s\"' % (self.clientId()) + ", "
      v = v + 'agent = \"%s\"' % (self.agent()) + ", "
      v = v + 'sysDesc = %u' % (self.sysDesc()) + ", "
      v = v + 'tid = %u' % (self.tid()) + ", "
      v = v + 'scheduled = %u' % (self.scheduled()) + ", "
      v = v + 'clientType = %u' % (self.clientType()) + ", "
      v = v + 'properties = %u' % (self.properties()) + ", "
      v = v + 'activity = \"%s\"' % (self.activity())
      return v
