
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from SubscriptionCtrl.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class SubscriptionCtrl( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::SubscriptionCtrl"

   @staticmethod
   def protRowType( ):
     return SubscriptionCtrl.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( SubscriptionCtrl.rowType_ == 0 ) or
         ( SubscriptionCtrl.rowType_ == rowTypeId )):
       SubscriptionCtrl.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, SubscriptionCtrl.rowType_,
                                 SubscriptionCtrl.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(SubscriptionCtrl, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(SubscriptionCtrl, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "SubscriptionCtrl" )
      else:
         super(SubscriptionCtrl, self).__init__( length =  27 )

   def agentName(self):
      return self.strFrom( 4 )
   def connection_id(self):
      return self.strFrom( 8 )
   def tablePath(self):
      return self.strFrom( 12 )
   def ptime(self):
      return self.extU64( 16 )
   def readerReady(self):
      return self.extBool( 24 )
   def tableState(self):
      return self.extU8( 25 )
   def overrideHandshake(self):
      return self.extBool( 26 )

   def agentNameIs( self, v ):
      return self.insertString( 4, v )
   def connection_idIs( self, v ):
      return self.insertString( 8, v )
   def tablePathIs( self, v ):
      return self.insertString( 12, v )
   def ptimeIs( self, v ):
      return self.insertU64( 16, v )
   def readerReadyIs( self, v ):
      return self.insertBool( 24, v )
   def tableStateIs( self, v ):
      return self.insertU8( 25, v )
   def overrideHandshakeIs( self, v ):
      return self.insertBool( 26, v )



   def __eq__( self, o ):
      return self.connection_id() == o.connection_id() and \
             self.tablePath() == o.tablePath()

   def __hash__( self ):
      l = ( self.connection_id(), self.tablePath() )
      return hash( l )

   def __lt__( self, o ):
      if self.connection_id() < o.connection_id():
         return True
      if self.connection_id() > o.connection_id():
         return False
      if self.tablePath() < o.tablePath():
         return True
      if self.tablePath() > o.tablePath():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.agentName() == o.agentName() and \
             self.connection_id() == o.connection_id() and \
             self.tablePath() == o.tablePath() and \
             self.ptime() == o.ptime() and \
             self.readerReady() == o.readerReady() and \
             self.tableState() == o.tableState() and \
             self.overrideHandshake() == o.overrideHandshake()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'agentName = \"%s\"' % (self.agentName()) + ", "
      v = v + 'connection_id = \"%s\"' % (self.connection_id()) + ", "
      v = v + 'tablePath = \"%s\"' % (self.tablePath()) + ", "
      v = v + 'ptime = %u' % (self.ptime()) + ", "
      v = v + 'readerReady = %s' % (self.formatBool(self.readerReady())) + ", "
      v = v + 'tableState = %u' % (self.tableState()) + ", "
      v = v + 'overrideHandshake = %s' % (self.formatBool(self.overrideHandshake()))
      return v
