
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from QueryStatus.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class QueryStatus( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::QueryStatus"

   @staticmethod
   def protRowType( ):
     return QueryStatus.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( QueryStatus.rowType_ == 0 ) or
         ( QueryStatus.rowType_ == rowTypeId )):
       QueryStatus.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, QueryStatus.rowType_,
                                 QueryStatus.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(QueryStatus, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(QueryStatus, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "QueryStatus" )
      else:
         super(QueryStatus, self).__init__( length =  22 )

   def qiid(self):
      return self.extU32( 4 )
   def status(self):
      return self.extBool( 8 )
   def error(self):
      return self.strFrom( 9 )
   def quiesced(self):
      return self.extBool( 13 )
   def quiescenceGeneration(self):
      return self.extU64( 14 )

   def qiidIs( self, v ):
      return self.insertU32( 4, v )
   def statusIs( self, v ):
      return self.insertBool( 8, v )
   def errorIs( self, v ):
      return self.insertString( 9, v )
   def quiescedIs( self, v ):
      return self.insertBool( 13, v )
   def quiescenceGenerationIs( self, v ):
      return self.insertU64( 14, v )



   def __eq__( self, o ):
      return self.qiid() == o.qiid()

   def __hash__( self ):
      l = ( self.qiid() )
      return hash( l )

   def __lt__( self, o ):
      if self.qiid() < o.qiid():
         return True
      if self.qiid() > o.qiid():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qiid() == o.qiid() and \
             self.status() == o.status() and \
             self.error() == o.error() and \
             self.quiesced() == o.quiesced() and \
             self.quiescenceGeneration() == o.quiescenceGeneration()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qiid = %u' % (self.qiid()) + ", "
      v = v + 'status = %s' % (self.formatBool(self.status())) + ", "
      v = v + 'error = \"%s\"' % (self.error()) + ", "
      v = v + 'quiesced = %s' % (self.formatBool(self.quiesced())) + ", "
      v = v + 'quiescenceGeneration = %u' % (self.quiescenceGeneration())
      return v
