
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from QueryStatisticsRequest.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class QueryStatisticsRequest( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::QueryStatisticsRequest"

   @staticmethod
   def protRowType( ):
     return QueryStatisticsRequest.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( QueryStatisticsRequest.rowType_ == 0 ) or
         ( QueryStatisticsRequest.rowType_ == rowTypeId )):
       QueryStatisticsRequest.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, QueryStatisticsRequest.rowType_,
                                 QueryStatisticsRequest.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(QueryStatisticsRequest, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(QueryStatisticsRequest, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "QueryStatisticsRequest" )
      else:
         super(QueryStatisticsRequest, self).__init__( length =  24 )

   def qiid(self):
      return self.extU32( 4 )
   def generation(self):
      return self.extU64( 8 )
   def quiescenceGeneration(self):
      return self.extU64( 16 )

   def qiidIs( self, v ):
      return self.insertU32( 4, v )
   def generationIs( self, v ):
      return self.insertU64( 8, v )
   def quiescenceGenerationIs( self, v ):
      return self.insertU64( 16, v )



   def __eq__( self, o ):
      return self.qiid() == o.qiid()

   def __hash__( self ):
      l = ( self.qiid() )
      return hash( l )

   def __lt__( self, o ):
      if self.qiid() < o.qiid():
         return True
      if self.qiid() > o.qiid():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qiid() == o.qiid() and \
             self.generation() == o.generation() and \
             self.quiescenceGeneration() == o.quiescenceGeneration()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qiid = %u' % (self.qiid()) + ", "
      v = v + 'generation = %u' % (self.generation()) + ", "
      v = v + 'quiescenceGeneration = %u' % (self.quiescenceGeneration())
      return v
