
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from QueryStatistics.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class QueryStatistics( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::arCtrl::QueryStatistics"

   @staticmethod
   def protRowType( ):
     return QueryStatistics.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( QueryStatistics.rowType_ == 0 ) or
         ( QueryStatistics.rowType_ == rowTypeId )):
       QueryStatistics.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, QueryStatistics.rowType_,
                                 QueryStatistics.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(QueryStatistics, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(QueryStatistics, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "QueryStatistics" )
      else:
         super(QueryStatistics, self).__init__( length =  37 )

   def qiid(self):
      return self.extU32( 4 )
   def tableParamName(self):
      return self.strFrom( 8 )
   def generation(self):
      return self.extU64( 12 )
   def direction(self):
      return self.extU8( 20 )
   def readWriteCount(self):
      return self.extU64( 21 )
   def sigDelCount(self):
      return self.extU64( 29 )

   def qiidIs( self, v ):
      return self.insertU32( 4, v )
   def tableParamNameIs( self, v ):
      return self.insertString( 8, v )
   def generationIs( self, v ):
      return self.insertU64( 12, v )
   def directionIs( self, v ):
      return self.insertU8( 20, v )
   def readWriteCountIs( self, v ):
      return self.insertU64( 21, v )
   def sigDelCountIs( self, v ):
      return self.insertU64( 29, v )



   def __eq__( self, o ):
      return self.qiid() == o.qiid() and \
             self.tableParamName() == o.tableParamName()

   def __hash__( self ):
      l = ( self.qiid(), self.tableParamName() )
      return hash( l )

   def __lt__( self, o ):
      if self.qiid() < o.qiid():
         return True
      if self.qiid() > o.qiid():
         return False
      if self.tableParamName() < o.tableParamName():
         return True
      if self.tableParamName() > o.tableParamName():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.qiid() == o.qiid() and \
             self.tableParamName() == o.tableParamName() and \
             self.generation() == o.generation() and \
             self.direction() == o.direction() and \
             self.readWriteCount() == o.readWriteCount() and \
             self.sigDelCount() == o.sigDelCount()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'qiid = %u' % (self.qiid()) + ", "
      v = v + 'tableParamName = \"%s\"' % (self.tableParamName()) + ", "
      v = v + 'generation = %u' % (self.generation()) + ", "
      v = v + 'direction = %u' % (self.direction()) + ", "
      v = v + 'readWriteCount = %u' % (self.readWriteCount()) + ", "
      v = v + 'sigDelCount = %u' % (self.sigDelCount())
      return v
