
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from Handshake.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class Handshake( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::Protocol::Handshake"

   @staticmethod
   def protRowType( ):
     return Handshake.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( Handshake.rowType_ == 0 ) or
         ( Handshake.rowType_ == rowTypeId )):
       Handshake.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, Handshake.rowType_,
                                 Handshake.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(Handshake, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(Handshake, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "Handshake" )
      else:
         super(Handshake, self).__init__( length =  10 )

   def protocolVersion(self):
      return self.extU16( 4 )
   def controlRowType(self):
      return self.extU32( 6 )

   def protocolVersionIs( self, v ):
      return self.insertU16( 4, v )
   def controlRowTypeIs( self, v ):
      return self.insertU32( 6, v )



   def __eq__( self, o ):
      return self.protocolVersion() == o.protocolVersion() and \
             self.controlRowType() == o.controlRowType()

   def __hash__( self ):
      l = ( self.protocolVersion(), self.controlRowType() )
      return hash( l )

   def __lt__( self, o ):
      if self.protocolVersion() < o.protocolVersion():
         return True
      if self.protocolVersion() > o.protocolVersion():
         return False
      if self.controlRowType() < o.controlRowType():
         return True
      if self.controlRowType() > o.controlRowType():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.protocolVersion() == o.protocolVersion() and \
             self.controlRowType() == o.controlRowType()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'protocolVersion = %u' % (self.protocolVersion()) + ", "
      v = v + 'controlRowType = %u' % (self.controlRowType())
      return v
