
#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# this code was automatically generated from Control.aql.
# any modifications will be lost

from baseRow import BaseRow
from baseRow import ArrowTypes



class Control( BaseRow ):

   rowType_ = 0


   @staticmethod
   def rowTypeName():
     return "Arrow::Protocol::Control"

   @staticmethod
   def protRowType( ):
     return Control.rowType_

   @staticmethod
   def _rowTypeIdIs( rowTypeId ):
     if (( Control.rowType_ == 0 ) or
         ( Control.rowType_ == rowTypeId )):
       Control.rowType_ = rowTypeId
     else:
       msg = "RowTypeId %d incompatible with existing id (%d) for type %s"
       raise ValueError( msg % ( rowTypeId, Control.rowType_,
                                 Control.rowTypeName() ))


   def __init__( self, **kw ):
      if len( kw ) != 0:
         if 'row' in kw:
            super(Control, self).__init__( row = kw['row'] )
         elif 'length' in kw:
            rowLen = kw['length']
            super(Control, self).__init__( length = rowLen )

         else:
            assert False, \
               "invalid construction options %s for row type %s" % \
               ( kw, "Control" )
      else:
         super(Control, self).__init__( length =  14 )

   def msgType(self):
      return self.extU16( 4 )
   def tableId(self):
      return self.extU32( 6 )
   def tablePath(self):
      return self.strFrom( 10 )

   def msgTypeIs( self, v ):
      return self.insertU16( 4, v )
   def tableIdIs( self, v ):
      return self.insertU32( 6, v )
   def tablePathIs( self, v ):
      return self.insertString( 10, v )



   def __eq__( self, o ):
      return self.msgType() == o.msgType() and \
             self.tableId() == o.tableId() and \
             self.tablePath() == o.tablePath()

   def __hash__( self ):
      l = ( self.msgType(), self.tableId(), self.tablePath() )
      return hash( l )

   def __lt__( self, o ):
      if self.msgType() < o.msgType():
         return True
      if self.msgType() > o.msgType():
         return False
      if self.tableId() < o.tableId():
         return True
      if self.tableId() > o.tableId():
         return False
      if self.tablePath() < o.tablePath():
         return True
      if self.tablePath() > o.tablePath():
         return False

      return False
      
   def __str__( self ):
      return self.toString()

   def rowEquals( self, o ):
      return self.msgType() == o.msgType() and \
             self.tableId() == o.tableId() and \
             self.tablePath() == o.tablePath()

   def toString( self ):
      if not self:
         return "len = 0, Null"
      v = ''
      v = v + 'msgType = %u' % (self.msgType()) + ", "
      v = v + 'tableId = %u' % (self.tableId()) + ", "
      v = v + 'tablePath = \"%s\"' % (self.tablePath())
      return v
